#!/usr/local/cpanel/3rdparty/bin/perl
###############################################################################
# Copyright 2004-2020, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
# start main
use strict;
use Path::Tiny;
use IPC::Open3;
use Fcntl qw(:DEFAULT :flock);

our ($installed, $option, $cpanel);

my ($childin, $childout);
my $cmdpid = open3($childin, $childout, $childout, "mount | grep /var/spool/exim");
my @output = <$childout>;
waitpid ($cmdpid, 0);
chomp @output;
if ($output[0] ne "") {	
	die "**** Failed: MailScanner cannot work if /var/spool/exim is a separate mounted filesystem ****";
}

$installed = 0;
if (-d "/usr/mailscanner/") {$installed = 1}

$cpanel = 1;
unless (-e "/usr/local/cpanel/version") {$cpanel = 0}

if ($ARGV[0] eq "") {
	die "This script is not to be run directly";
}
$option = $ARGV[0];

if ($installed) {
	if (($option ne "1") and ($option ne "2") and ($option ne "3") and ($option ne "9")) {print "Only 1,2,3 and 9 are valid\n"; exit;}
} else {
	if (($option ne "1") and ($option ne "2") and ($option ne "9")) {print "Only 1,2 and 9 are valid\n"; exit;}
}
if ($option eq "9") {print "Bye!\n"; exit;}

if ($installed and $option eq "3") {
	print "Removing MailScanner...\n\n";

	if ($cpanel) {
		print "Updating Config and Restarting Exim...\n";
		unlink ("/etc/antivirus.empty");
		open (IN,"<", "/etc/exim.conf.localopts");
		flock (IN, LOCK_SH);
		my @localopts = <IN>;
		close (IN);
		chomp @localopts;
		sysopen (OUT, "/etc/exim.conf.localopts", O_WRONLY | O_CREAT | O_TRUNC);
		flock (OUT, LOCK_EX);
		foreach my $line (@localopts) {
			if ($line !~ /^systemfilter/) {print OUT "$line\n"}
		}
		print OUT "systemfilter=/etc/antivirus.exim\n";
		close OUT;
		
		unlink ("/etc/exim_outgoing.conf");
		unlink ("/etc/exiscandisable");

		open (IN, "<", "/etc/exim.conf.local");
		flock (IN, LOCK_SH);
		my @exim_conf_local = <IN>;
		close (IN);
		chomp @exim_conf_local;
		sysopen (OUT, "/etc/exim.conf.local", O_WRONLY | O_CREAT | O_TRUNC);
		flock (OUT, LOCK_EX);
		foreach my $line (@exim_conf_local) {
			if ($line =~ /message_logs = false/) {next}
			if ($line =~ /queue_only_override = false/) {next}
			if ($line =~ /\.include_if_exists \/usr\/msfe\/spambox\.conf/) {next}
			print OUT "$line\n";
		}
		close (OUT);

		foreach my $file ("/usr/local/cpanel/etc/exim/acls/ACL_MAIL_PRE_BLOCK/custom_begin_mail_pre", "/usr/local/cpanel/etc/exim/acls/ACL_MAIL_POST_BLOCK/custom_begin_mail_post") {
			open (my $ACL, "<", $file);
			flock ($ACL, LOCK_SH);
			my @acl_config = <$ACL>;
			close ($ACL);
			chomp @acl_config;
			sysopen (OUT, "$file", O_WRONLY | O_CREAT | O_TRUNC);
			flock (OUT, LOCK_EX);
			foreach my $line (@acl_config) {
				if ($line =~ /\.include_if_exists \/usr\/msfe\/mailscannerq\.conf/) {next}
				print OUT "$line\n";
			}
			close (OUT);
		}

		system("/scripts/buildeximconf");
		system("/scripts/restartsrv_exim");
		print "Done\n";

		open (IN,"<", "/etc/chkserv.d/chkservd.conf");
		flock (IN, LOCK_SH);
		my @chkservd = <IN>;
		close (IN);
		chomp @chkservd;
		sysopen (OUT, "/etc/chkserv.d/chkservd.conf", O_WRONLY | O_CREAT | O_TRUNC);
		flock (OUT, LOCK_EX);
		foreach my $line (@chkservd) {
			if ($line !~ /^mailscanner/) {print OUT "$line\n"}
		}
		close OUT;
	}

	unlink ("/usr/msfe/mailscannerq");

	print "Stopping MailScanner and cron jobs...\n";
	system ("killall", "-9", "MailScanner");
	unlink ("/etc/cron.daily/clean.quarantine.cron");
	unlink ("/etc/cron.daily/clean.incoming.cron");
	unlink ("/etc/cron.hourly/update_virus_scanners");
	unlink ("/etc/chkserv.d/mailscanner");
	unlink ("/var/run/chkservd/mailscanner");
	unlink "/etc/mail/spamassassin/mailscanner.cf";
	print "Done\n";

	print "Removing MailScanner directories...\n";
	if (-d "/usr/mailscanner/") {system ("/bin/rm -Rf /usr/mailscanner/")}
	if (-d "/var/spool/MailScanner/") {system ("/bin/rm -Rf /var/spool/MailScanner/")}
	if (-d "/var/spool/exim_incoming/") {
		system ("/bin/cp -avf /var/spool/exim_incoming/input/* /var/spool/exim/input/");
		system ("/bin/rm -Rf /var/spool/exim_incoming/");
	}
	if (-d "/var/spool/exim/mailscanner/") {
		system ("/bin/cp -avf /var/spool/exim/mailscanner/input/* /var/spool/exim/input/");
		system ("/bin/rm -Rf /var/spool/exim/mailscanner/");
	}
	if (-d "/var/spool/mqueue/") {system ("/bin/rm -Rf /var/spool/mqueue/")}
	print "Done\n";

	print "All Done\n";
} else {
	opendir (TMPDIR, "/tmp");
	while (my $file = readdir(TMPDIR)) {
		my $fullfile = "/tmp/$file";
		if ($fullfile =~ m[/tmp/tmp\.\w+] and -O $fullfile) {unlink $fullfile}
	}
	closedir (TMPDIR);
	print "Removing old distributions...\n";
	if (-d "/usr/mailscanner.new/") {system ("/bin/rm -Rf /usr/mailscanner.new/")}
	if (-d "/usr/mailscanner.old/") {system ("/bin/rm -Rf /usr/mailscanner.old/")}

	print "Done\n";

	if ($cpanel) {
		print "Setting up system_filter to /etc/antivirus.empty\n";
		system ("touch /etc/antivirus.empty");
		open (IN,"<", "/etc/exim.conf.localopts");
		flock (IN, LOCK_SH);
		my @localopts = <IN>;
		close (IN);
		chomp @localopts;
		sysopen (OUT, "/etc/exim.conf.localopts", O_WRONLY | O_CREAT | O_TRUNC);
		flock (OUT, LOCK_EX);
		foreach my $line (@localopts) {
			if ($line !~ /^systemfilter/) {print OUT "$line\n"}
		}
		print OUT "systemfilter=/etc/antivirus.empty\n";
		close OUT;
	}

	if ($installed) {
		print "\nUpgrading existing installation\n\n";

		print "Updating location path...\n";
		if (-e "/usr/mailscanner/bin") {
			system ("/bin/cp -af /usr/mailscanner /usr/mailscanner.prev5");
		}
		system ("/bin/cp -af MailScanner/ /usr/mailscanner.new");
		system ('find /usr/mailscanner.new/ -type f -exec sed -i "s%/etc/MailScanner%/usr/mailscanner/etc%g" {} \;');
		system ('find /usr/mailscanner.new/ -type f -exec sed -i "s%/usr/lib/MailScanner/%/usr/mailscanner/usr/lib/MailScanner/%g" {} \;');
		system ('find /usr/mailscanner.new/ -type f -exec sed -i "s%/usr/sbin/%/usr/mailscanner/usr/sbin/%g" {} \;');
		system ('find /usr/mailscanner.new/ -type f -exec sed -i "s%/usr/share/MailScanner/%/usr/mailscanner/usr/share/MailScanner/%g" {} \;');
		system ("mv -f /usr/mailscanner.new/etc/MailScanner/* /usr/mailscanner.new/etc/");
		print "Done\n";

		print "Preserving existing configuration files...\n";
		system ("/bin/rm -f /usr/mailscanner/etc/MailScanner.conf.new /usr/mailscanner/etc/MailScanner.conf.old");
		system ("/bin/mv -f /usr/mailscanner.new/etc/MailScanner.conf /usr/mailscanner.new/etc/MailScanner.conf.new");
		system ("/bin/cp -af /usr/mailscanner/etc/* /usr/mailscanner.new/etc/");
		if (-e "/usr/mailscanner.new/etc/reports") {
			system ("rm -Rf /usr/mailscanner.new/etc/reports");
		}
		print "Done\n";

		print "Upgrading MailScanner.conf...\n";
		system ("chmod +x /usr/mailscanner.new/usr/sbin/*");
		system ("/usr/mailscanner.new/usr/sbin/ms-upgrade-conf /usr/mailscanner.new/etc/MailScanner.conf /usr/mailscanner.new/etc/MailScanner.conf.new > /usr/mailscanner.new/etc/MailScanner.new 2>/dev/null");
		system ("/bin/mv -f /usr/mailscanner.new/etc/MailScanner.conf /usr/mailscanner.new/etc/MailScanner.old");
		system ("/bin/mv -f /usr/mailscanner.new/etc/MailScanner.new  /usr/mailscanner.new/etc/MailScanner.conf");

		print "Updating MailScanner.conf with sensible values. Generating rulesets if necessary...\n";
		open (IN, "<", "/usr/mailscanner.new/etc/MailScanner.conf");
		flock (IN, LOCK_SH);
		my @mailscanner_conf = <IN>;
		close (IN);
		chomp @mailscanner_conf;

		sysopen (OUT, "/usr/mailscanner.new/etc/MailScanner.conf", O_WRONLY | O_CREAT | O_TRUNC);
		flock (OUT, LOCK_EX);
		foreach my $line (@mailscanner_conf) {
			if ($line =~ /^Incoming Queue Dir =/) {$line = "Incoming Queue Dir = /var/spool/exim_incoming/input/*"}
			if ($line =~ /^Split Exim Spool =/) {$line = "Split Exim Spool = yes"}
			if ($line =~ /^Sendmail =/) {$line = "Sendmail = /usr/sbin/exim -oMr MailScanner"}
			if ($line =~ /^Sendmail2 =/) {$line = "Sendmail2 = /usr/sbin/exim -C /etc/exim_outgoing.conf"}
			if ($line =~ /^Run As User =/) {
				if ($cpanel) {
					$line = "Run As User = mailnull";
				} else {
					$line = "Run As User = mail";
				}
			}
			if ($line =~ /^PID file =/) {$line = "PID file = /var/run/MailScanner.pid"}
			if ($line =~ /^Spam Checks =/) {$line = "Spam Checks = \%rules-dir\%/spam.scanning.rules"}
			if ($line =~ /^Use SpamAssassin =/) {$line = "Use SpamAssassin = \%rules-dir\%/spam.scanning.rules"}
			if ($line =~ /^Unrar Command = /) {$line = "Unrar Command = "}
			if ($line =~ /^TNEF Expander =/) {$line = "TNEF Expander = internal"}
			if ($line =~ /^Use TNEF Contents =/) {$line = "Use TNEF Contents = no"}
			if ($line =~ /^Expand TNEF =/) {$line = "Expand TNEF = yes"}
			if ($line =~ /^Find UU-Encoded Files =/) {$line = "Find UU-Encoded Files = yes"}
			if ($line =~ /^Monitors for ClamAV Updates =/) {$line = "Monitors for ClamAV Updates = /usr/local/share/clamav/*.cvd /usr/local/share/clamav/daily.inc/daily.info"}
			if ($line =~ /^Spam Actions =/) {$line = "Spam Actions = \%rules-dir\%/spam.action.rules"}
			if ($line =~ /^High Scoring Spam Actions =/) {$line = "High Scoring Spam Actions = \%rules-dir\%/spamhigh.action.rules"}
			if ($line =~ /^Virus Scanning =/) {$line = "Virus Scanning = \%rules-dir\%/virus.scanning.rules"}
			if ($line =~ /^Dangerous Content Scanning =/) {$line = "Dangerous Content Scanning = \%rules-dir\%/virus.scanning.rules"}
			if ($line =~ /^Still Deliver Silent Viruses =/) {$line = "Still Deliver Silent Viruses = \%rules-dir\%/virus.delivery.rules"}
			if ($line =~ /^Deliver Cleaned Messages =/) {$line = "Deliver Cleaned Messages = \%rules-dir\%/virus.delivery.rules"}
			if ($line =~ /^Is Definitely Not Spam =/) {$line = "Is Definitely Not Spam = \%rules-dir\%/spam.whitelist.rules"}
			if ($line =~ /^Is Definitely Spam =/) {$line = "Is Definitely Spam = \%rules-dir\%/spam.blacklist.rules"}
			if ($line =~ /^Required SpamAssassin Score =/) {$line = "Required SpamAssassin Score = \%rules-dir\%/spam.score.rules"}
			if ($line =~ /^High SpamAssassin Score =/) {$line = "High SpamAssassin Score = \%rules-dir\%/spamhigh.score.rules"}
			if ($line =~ /^Filename Rules =/) {$line = "Filename Rules = \%rules-dir\%/filename.rules.rules"}
			if ($line =~ /^Filetype Rules =/) {$line = "Filetype Rules = \%rules-dir\%/filetype.rules.rules"}
			if ($line =~ /^Custom Functions Dir =/) {$line = "Custom Functions Dir = /usr/mailscanner/usr/share/MailScanner/perl/custom"}
			if ($line =~ /^%report-dir% = .*\/(\w+)$/) {$line = "\%report-dir\% = /usr/mailscanner/usr/share/MailScanner/reports/$1"}
			if ($line =~ /^Maximum Processing Attempts =/) {$line = "Maximum Processing Attempts = 0"}
			if ($line =~ /^Non Spam Actions = store deliver header X-Spam-Status: No/) {$line = "Non Spam Actions = store deliver header \"X-Spam-Status: No\""}
			if ($line =~ /^Non Spam Actions = deliver header X-Spam-Status: No/) {$line = "Non Spam Actions = deliver header \"X-Spam-Status: No\""}
			print OUT "$line\n";
		}
		close (OUT);

		if (!-e "/usr/mailscanner.new/etc/rules/spam.scanning.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spam.scanning.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (only spam scan incoming email)\n";
			print RULE "\# To:\t*\@mydomain.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/spam.action.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spam.action.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (could be 'delete' or 'forward spam\@mydomain.com delete' or 'deliver'  - without quote marks)\n";
			print RULE "\# To:\t*\@mydomain.com\tdeliver\n";
			print RULE "FromOrTo:\tdefault\tdeliver\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/spamhigh.action.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spamhigh.action.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (could be 'delete' or 'forward spam\@mydomain.com delete' or 'deliver'  - without quote marks)\n";
			print RULE "\# To:\t*\@mydomain.com\tdeliver\n";
			print RULE "FromOrTo:\tdefault\tdeliver\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/virus.scanning.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/virus.scanning.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (virus scan in and out going email)\n";
			print RULE "\# FromOrTo:\t*\@mydomain.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/virus.delivery.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/virus.delivery.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (deliver messages with viruses after the virus has been removed)\n";
			print RULE "\# FromOrTo:\t*\@mydomain.com\tno\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/spam.whitelist.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spam.whitelist.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (block foo\@bar.com)\n";
			print RULE "\# To:\tfoo\@bar.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/spam.blacklist.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spam.blacklist.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (allow from foo\@bar.com)\n";
			print RULE "\# From:\tfoo\@bar.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/spam.score.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spam.score.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t5\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/spamhigh.score.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/spamhigh.score.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t20\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/filename.rules.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/filename.rules.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t/usr/mailscanner/etc/filename.rules.conf\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/filename.no.rules.conf") {
			flock (RULE, LOCK_EX);
			open (RULE, ">", "/usr/mailscanner.new/etc/filename.no.rules.conf");
			print RULE "allow\t.\t-\t-\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/rules/filetype.rules.rules") {
			open (RULE, ">", "/usr/mailscanner.new/etc/rules/filetype.rules.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t/usr/mailscanner/etc/filetype.rules.conf\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner.new/etc/filetype.no.rules.conf") {
			open (RULE, ">", "/usr/mailscanner.new/etc/filetype.no.rules.conf");
			flock (RULE, LOCK_EX);
			print RULE "allow\t.\t-\t-\n";
			close (RULE);
		}
		print "Done\n";

		system ("/bin/mv -f /usr/mailscanner /usr/mailscanner.old");
		system ('find /usr/mailscanner.old -type d -exec chmod 700 {} \;');
		system ("chmod", "700", "/usr/mailscanner.old");
		system ("/bin/mv -f /usr/mailscanner.new /usr/mailscanner");
	} else {
		print "\nAdding new installation\n\n";
		system ("/bin/cp -af MailScanner/ /usr/mailscanner 2>/dev/null");

		print "Updating location path...\n";
		system ("chmod +x /usr/mailscanner/usr/sbin/*");
		system ('find /usr/mailscanner/ -type f -exec sed -i "s%/etc/MailScanner%/usr/mailscanner/etc%g" {} \;');
		system ('find /usr/mailscanner/ -type f -exec sed -i "s%/usr/lib/MailScanner/%/usr/mailscanner/usr/lib/MailScanner/%g" {} \;');
		system ('find /usr/mailscanner/ -type f -exec sed -i "s%/usr/sbin/%/usr/mailscanner/usr/sbin/%g" {} \;');
		system ('find /usr/mailscanner/ -type f -exec sed -i "s%/usr/share/MailScanner/%/usr/mailscanner/usr/share/MailScanner/%g" {} \;');
		system ("mv -f /usr/mailscanner/etc/MailScanner/* /usr/mailscanner/etc/");
		print "Done\n";

		print "Updating MailScanner.conf with sensible values...\n";
		open (IN, "<", "/usr/mailscanner/etc/MailScanner.conf");
		flock (IN, LOCK_SH);
		my @mailscanner_conf = <IN>;
		close (IN);
		chomp @mailscanner_conf;

		sysopen (OUT, "/usr/mailscanner/etc/MailScanner.conf", O_WRONLY | O_CREAT | O_TRUNC);
		flock (OUT, LOCK_EX);
		foreach my $line (@mailscanner_conf) {
			if ($line =~ /^MTA =/) {$line = "MTA = exim"}
			if ($line =~ /^TNEF Expander =/) {$line = "TNEF Expander = internal"}
			if ($line =~ /^Use TNEF Contents =/) {$line = "Use TNEF Contents = no"}
			if ($line =~ /^Expand TNEF =/) {$line = "Expand TNEF = yes"}
			if ($line =~ /^Sendmail =/) {$line = "Sendmail = /usr/sbin/exim -oMr MailScanner"}
			if ($line =~ /^Sendmail2 =/) {$line = "Sendmail2 = /usr/sbin/exim -C /etc/exim_outgoing.conf"}
			if ($line =~ /^PID file =/) {$line = "PID file = /var/run/MailScanner.pid"}
			if ($line =~ /^Incoming Queue Dir =/) {$line = "Incoming Queue Dir = /var/spool/exim_incoming/input/*"}
			if ($line =~ /^Split Exim Spool =/) {$line = "Split Exim Spool = yes"}
			if ($line =~ /^Outgoing Queue Dir =/) {$line = "Outgoing Queue Dir = /var/spool/exim/input"}
			if ($line =~ /^Run As User =/) {
				if ($cpanel) {
					$line = "Run As User = mailnull";
				} else {
					$line = "Run As User = mail";
				}
			}
			if ($line =~ /^Run As Group =/) {$line = "Run As Group = mail"}
			if ($line =~ /^Spam Checks =/) {$line = "Spam Checks = no"}
			if ($line =~ /^Max Children =/) {$line = "Max Children = 3"}
			if ($line =~ /^Unrar Command =/) {$line = "Unrar Command = "}
			if ($line =~ /^Still Deliver Silent Viruses =/) {$line = "Still Deliver Silent Viruses = no"}
			if ($line =~ /^\%org-name\% =/) {$line = "%org-name% = YourOrg"}
			if ($line =~ /^Deliver Unparsable TNEF =/) {$line = "Deliver Unparsable TNEF = yes"}
			if ($line =~ /^File Command =/) {$line = "File Command = /usr/bin/file"}
			if ($line =~ /^Allow Password-Protected Archives =/) {$line = "Allow Password-Protected Archives = yes"}
			if ($line =~ /^Find Phishing Fraud =/) {$line = "Find Phishing Fraud = no"}
			if ($line =~ /^Minimum Stars If On Spam List =/) {$line = "Minimum Stars If On Spam List = 20"}
			if ($line =~ /^Always Include SpamAssassin Report =/) {$line = "Always Include SpamAssassin Report = no"}
			if ($line =~ /^High Scoring Spam Subject Text =/) {$line = "High Scoring Spam Subject Text = \{Definitely Spam?\}"}
			if ($line =~ /^Spam List =/) {
				if ($cpanel) {
					$line = "Spam List = ";
				} else {
					$line = "Spam List = SPAMHAUS SPAMCOP";
				}
			}
			if ($line =~ /^Max Spam Check Size =/) {$line = "Max Spam Check Size = 600k"}
			if ($line =~ /^Spam Lists To Reach High Score =/) {$line = "Spam Lists To Reach High Score = 1"}
			if ($line =~ /^Definite Spam Is High Scoring =/) {$line = "Definite Spam Is High Scoring = yes"}
			if ($line =~ /^Required SpamAssassin Score =/) {$line = "Required SpamAssassin Score = 5"}
			if ($line =~ /^High SpamAssassin Score =/) {$line = "High SpamAssassin Score = 20"}
			if ($line =~ /^Send Notices =/) {$line = "Send Notices = no"}
			if ($line =~ /^Sign Clean Messages =/) {$line = "Sign Clean Messages = no"}
			if ($line =~ /^SpamAssassin Auto Whitelist =/) {$line = "SpamAssassin Auto Whitelist = no"}
			if ($line =~ /^Check SpamAssassin If On Spam List =/) {$line = "Check SpamAssassin If On Spam List = no"}
			if ($line =~ /^Always Include SpamAssassin Report =/) {$line = "Always Include SpamAssassin Report = yes"}
			if ($line =~ /^Spam Checks =/) {$line = "Spam Checks = \%rules-dir\%/spam.scanning.rules"}
			if ($line =~ /^Use SpamAssassin =/) {$line = "Use SpamAssassin = \%rules-dir\%/spam.scanning.rules"}
			if ($line =~ /^Find UU-Encoded Files =/) {$line = "Find UU-Encoded Files = yes"}
			if ($line =~ /^Monitors for ClamAV Updates =/) {$line = "Monitors for ClamAV Updates = /usr/local/share/clamav/*.cvd /usr/local/share/clamav/daily.inc/daily.info"}
			if ($line =~ /^Spam Actions =/) {$line = "Spam Actions = \%rules-dir\%/spam.action.rules"}
			if ($line =~ /^High Scoring Spam Actions =/) {$line = "High Scoring Spam Actions = \%rules-dir\%/spamhigh.action.rules"}
			if ($line =~ /^Virus Scanning =/) {$line = "Virus Scanning = \%rules-dir\%/virus.scanning.rules"}
			if ($line =~ /^Dangerous Content Scanning =/) {$line = "Dangerous Content Scanning = \%rules-dir\%/virus.scanning.rules"}
			if ($line =~ /^Still Deliver Silent Viruses =/) {$line = "Still Deliver Silent Viruses = \%rules-dir\%/virus.delivery.rules"}
			if ($line =~ /^Deliver Cleaned Messages =/) {$line = "Deliver Cleaned Messages = \%rules-dir\%/virus.delivery.rules"}
			if ($line =~ /^Is Definitely Not Spam =/) {$line = "Is Definitely Not Spam = \%rules-dir\%/spam.whitelist.rules"}
			if ($line =~ /^Is Definitely Spam =/) {$line = "Is Definitely Spam = \%rules-dir\%/spam.blacklist.rules"}
			if ($line =~ /^Required SpamAssassin Score =/) {$line = "Required SpamAssassin Score = \%rules-dir\%/spam.score.rules"}
			if ($line =~ /^High SpamAssassin Score =/) {$line = "High SpamAssassin Score = \%rules-dir\%/spamhigh.score.rules"}
			if ($line =~ /^Filename Rules =/) {$line = "Filename Rules = \%rules-dir\%/filename.rules.rules"}
			if ($line =~ /^Filetype Rules =/) {$line = "Filetype Rules = \%rules-dir\%/filetype.rules.rules"}
			if ($line =~ /^Custom Functions Dir =/) {$line = "Custom Functions Dir = /usr/mailscanner/usr/share/MailScanner/perl/custom"}
			if ($line =~ /^%report-dir% =/) {$line = "\%report-dir\% = /usr/mailscanner/usr/share/MailScanner/reports/en"}
			if ($line =~ /^Maximum Processing Attempts =/) {$line = "Maximum Processing Attempts = 0"}
			print OUT "$line\n";
		}
		close (OUT);

		if (!-e "/usr/mailscanner/etc/rules/spam.scanning.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spam.scanning.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (only spam scan incoming email)\n";
			print RULE "\# To:\t*\@mydomain.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/spam.action.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spam.action.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (could be 'delete' or 'forward spam\@mydomain.com delete' or 'deliver'  - without quote marks)\n";
			print RULE "\# To:\t*\@mydomain.com\tdeliver\n";
			print RULE "FromOrTo:\tdefault\tdeliver\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/spamhigh.action.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spamhigh.action.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (could be 'delete' or 'forward spam\@mydomain.com delete' or 'deliver'  - without quote marks)\n";
			print RULE "\# To:\t*\@mydomain.com\tdeliver\n";
			print RULE "FromOrTo:\tdefault\tdeliver\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/virus.scanning.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/virus.scanning.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (virus scan in and out going email)\n";
			print RULE "\# FromOrTo:\t*\@mydomain.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/virus.delivery.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/virus.delivery.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (deliver messages with viruses after the virus has been removed)\n";
			print RULE "\# FromOrTo:\t*\@mydomain.com\tno\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/spam.whitelist.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spam.whitelist.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (block foo\@bar.com)\n";
			print RULE "\# To:\tfoo\@bar.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/spam.blacklist.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spam.blacklist.rules");
			flock (RULE, LOCK_EX);
			print RULE "\# Example: (allow from foo\@bar.com)\n";
			print RULE "\# From:\tfoo\@bar.com\tyes\n";
			print RULE "FromOrTo:\tdefault\tno\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/spam.score.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spam.score.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t5\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/spamhigh.score.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/spamhigh.score.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t20\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/filename.rules.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/filename.rules.rules");
			print RULE "FromOrTo:\tdefault\t/usr/mailscanner/etc/filename.rules.conf\n";
			flock (RULE, LOCK_EX);
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/filename.no.rules.conf") {
			open (RULE, ">", "/usr/mailscanner/etc/filename.no.rules.conf");
			flock (RULE, LOCK_EX);
			print RULE "allow\t.\t-\t-\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/rules/filetype.rules.rules") {
			open (RULE, ">", "/usr/mailscanner/etc/rules/filetype.rules.rules");
			flock (RULE, LOCK_EX);
			print RULE "FromOrTo:\tdefault\t/usr/mailscanner/etc/filetype.rules.conf\n";
			close (RULE);
		}
		if (!-e "/usr/mailscanner/etc/filetype.no.rules.conf") {
			open (RULE, ">", "/usr/mailscanner/etc/filetype.no.rules.conf");
			flock (RULE, LOCK_EX);
			print RULE "allow\t.\t-\t-\n";
			close (RULE);
		}
		print "Done\n";
	}

	print "Updating file permissions...\n";
	mkdir ("/var/spool/MailScanner", 0750);
	mkdir ("/var/spool/MailScanner/incoming", 0750);
	mkdir ("/var/spool/MailScanner/incoming/Locks", 0750);
	mkdir ("/var/spool/MailScanner/quarantine", 0750);
	mkdir ("/var/spool/mqueue", 0750);
	system ('find /usr/mailscanner -type d -exec chmod 700 {} \;');
	system ("chmod", "700", "/usr/mailscanner");
	if ($cpanel) {
		system ("chown -R mailnull:mail /var/spool/MailScanner 2>/dev/null");
		system ("chown -R mailnull:mail /var/spool/mqueue 2>/dev/null");
		system ("chown", "-R", "mailnull:mail", "/usr/mailscanner");
	} else {
		system ("chown -R mail:mail /var/spool/MailScanner 2>/dev/null");
		system ("chown -R mail:mail /var/spool/mqueue 2>/dev/null");
		system ("chown", "-R", "mail:mail", "/usr/mailscanner");
	}

	if (-e "/usr/msfe/mschange.pl") {
		if (-e "/usr/msfe/mailscannerq") {
			print "New Queue system\n";
			system("/usr/msfe/mschange.pl 2");
		} else {
			print "Old Queue system\n";
			system("/usr/msfe/mschange.pl 1");
		}
	} else {
		if (-e "/usr/msfe/mailscannerq") {
			print "You need to install MSFE\n";
		} else {
			print "Checking spool directories...\n";
			mkdir ("/var/spool/exim_incoming", 0750);
			mkdir ("/var/spool/exim_incoming/db", 0750);
			mkdir ("/var/spool/exim_incoming/input", 0750);
			mkdir ("/var/spool/exim_incoming/msglog", 0750);

			print "Generating exim split spool directories...\n";
			foreach my $entry (('a'..'z','A'..'Z','0'..'9')) {
				mkdir ("/var/spool/exim_incoming/input/$entry");
				mkdir ("/var/spool/exim/input/$entry");
			}
			system ("chown -R mailnull:mail /var/spool/exim_incoming 2>/dev/null");
			system ("chown", "-R", "mailnull:mail", "/var/spool/exim/input/");
			system ("chmod", "-R", "750", "/var/spool/exim/input/");

			system ("find /home/ -maxdepth 2 -name .spamassassinenable | xargs rm -fv");
			print "Updating Exim Config...\n";

			open (OUT,">", "/etc/exim_outgoing.conf");
			flock (OUT, LOCK_EX);
			close (OUT);

			open (IN, "<", "/etc/exim.conf.local");
			flock (IN, LOCK_SH);
			my @exim_conf_local = <IN>;
			close (IN);
			chomp @exim_conf_local;
			if (scalar @exim_conf_local == 0) {
				@exim_conf_local = ('@AUTH@',' ','@BEGINACL@',' ','@CONFIG@',' ','@DIRECTOREND@',' ','@DIRECTORMIDDLE@',' ','@DIRECTORSTART@',' ','@ENDACL@',' ','@RETRYEND@',' ','@RETRYSTART@',' ','@REWRITE@',' ','@ROUTEREND@',' ','@ROUTERSTART@',' ','@TRANSPORTEND@',' ','@TRANSPORTMIDDLE@',' ','@TRANSPORTSTART@',' ');
			}
			my $ecl = "";
			unless (grep {$_ =~ /\@CONFIG\@/} @exim_conf_local) {push @exim_conf_local, '@CONFIG@'}
			unless (grep {$_ =~ /queue_only_override = false/} @exim_conf_local) {$ecl .= "queue_only_override = false\n"}
			unless (grep {$_ =~ /message_logs = false/} @exim_conf_local) {$ecl .= "message_logs = false\n"}
			sysopen (OUT, "/etc/exim.conf.local", O_WRONLY | O_CREAT | O_TRUNC);
			flock (OUT, LOCK_EX);
			foreach my $line (@exim_conf_local) {
				if ($line =~ /no_message_logs/) {next}
				print OUT "$line\n";
				if ($line eq "\@CONFIG\@") {print OUT "$ecl"}
			}
			close (OUT);
			system("/scripts/buildeximconf");
			system("/scripts/restartsrv_exim");
		}
	}

	print "Done\n";

	print "Adding MailScanner CRON jobs...\n";
	unlink "/etc/mail/spamassassin/mailscanner.cf";
	unlink "/etc/cron.daily/clean.quarantine.cron";
	system ("chmod +x clean.incoming.cron");
	system ("/bin/cp -af clean.incoming.cron /etc/cron.daily/");
	system ("ln -s /usr/mailscanner/usr/sbin/ms-clean-quarantine /etc/cron.daily/clean.quarantine.cron");
	replace ('disabled = 1', 'disabled = 0', "/usr/mailscanner/usr/sbin/ms-clean-quarantine");
	replace ('q_days=30', 'q_days=7', "/usr/mailscanner/etc/defaults");
	replace ('#bayes_path /usr/mailscanner/etc/bayes/bayes', 'bayes_path /var/spool/mqueue/.spamassassin/bayes', "/usr/mailscanner/etc/spamassassin.conf");
	system ("ln -s /usr/mailscanner/etc/spamassassin.conf /etc/mail/spamassassin/mailscanner.cf");
	if (-e "/etc/cron.hourly/update_virus_scanners") {system ("/bin/rm -f /etc/cron.hourly/update_virus_scanners")}
	unless (-e "/etc/exiscandisable") {
		system ("ln -s /usr/mailscanner/usr/sbin/ms-update-vs /etc/cron.hourly/update_virus_scanners");
	}
	system ("chmod +x /usr/mailscanner/usr/lib/MailScanner/wrapper/*");

	open (PRE,">", "/etc/mail/spamassassin/mailscanner.pre");
	flock (PRE, LOCK_EX);
	print PRE "loadplugin Mail::SpamAssassin::Plugin::AutoLearnThreshold\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::Bayes\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::BodyEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::Check\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::DNSEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::FreeMail\n";
	print PRE "#loadplugin Mail::SpamAssassin::Plugin::Hashcash\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::HeaderEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::HTMLEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::HTTPSMismatch\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::ImageInfo\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::MIMEEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::MIMEHeader\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::Pyzor\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::Razor2\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::RelayEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::ReplaceTags\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::Shortcircuit\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::SpamCop\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::SPF\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::URIDetail\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::URIDNSBL\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::URIEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::VBounce\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::WhiteListSubject\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::WLBLEval\n";
	print PRE "loadplugin Mail::SpamAssassin::Plugin::DCC\n";
	close (PRE);
	print "Done\n";

	if ($cpanel) {
		open (OUT,">", "/etc/chkserv.d/mailscanner");
		flock (OUT, LOCK_EX);
		print OUT "service[mailscanner]=x,x,x,service MailScanner restart,MailScanner,root|mailnull\n";
		close (OUT);
		open (IN,"<", "/etc/chkserv.d/chkservd.conf");
		flock (IN, LOCK_SH);
		my @chkservd = <IN>;
		close (IN);
		chomp @chkservd;
		if (not grep {$_ =~ /^mailscanner/} @chkservd) {
			sysopen (OUT, "/etc/chkserv.d/chkservd.conf", O_WRONLY | O_APPEND | O_CREAT);
			flock (OUT, LOCK_EX);
			print OUT "mailscanner:1\n";
			close OUT;
		}
		print "Done\n";
	}
}

exit;
###############################################################################
sub replace {
	my $from = shift;
	my $to = shift;
	my $file = shift;
	if (-e $file) {
		my $data = path($file)->slurp;
		eval {$data =~ s/$from/$to/g};
		path($file)->append({truncate => 1},$data);
	}
}
###############################################################################
